/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBCookies = Object.create(STBModule.prototype);

STBCookies.name = "Cookies";
STBCookies.showAccept = function() {
    try {
        if ($('.cookies-bar').length > 0) {
            
			var cookieBtn = $(".cookies-bar button"),
				holder = $(".cookies-bar"),
				over = $(".cookies-bar .generic-text"),
				buttons = $(".cookies-bar .buttons");


			if ($("html").attr("dir") == "rtl") {
				over.css("padding-left" , buttons.width() + 20);
			} else {
				over.css("padding-right" , buttons.width() + 20);
			}
			
			cookieBtn.click(function() {

                ajaxForm = $.ajax({
                    url: cookieBtn.attr("data-click"),
                    type: "post",
                    data: "set=1"
                }).done(function(msg){
					holder.fadeOut(function() {
						holder.remove();
					});
				});

			});		
        }

    } catch (e) {
        getStack(0, e);
    }
}

STBCookies.runOnReady = function() {
	STBCookies.showAccept();
}

site.registerModule(STBCookies);
